/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static dxb spriteGrass = null;
    private static dxb spriteGrassSide = null;
    private static dxb spriteGrassPath = null;
    private static dxb spriteGrassPathSide = null;
    private static dxb spriteMycelium = null;
    private static dxb spritePodzol = null;
    private static dxb spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static dyp modelCubeGrass = null;
    private static dyp modelGrassPath = null;
    private static dyp modelCubeGrassPath = null;
    private static dyp modelCubeMycelium = null;
    private static dyp modelCubePodzol = null;
    private static dyp modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(dxa textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            dyp modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(dxa textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new qv(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new qv(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new qv(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new qv(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new qv(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new qv(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new qv(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            qv locFile = new qv(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e2) {
            Config.warn("Error reading: " + name + ", " + e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    private static dxb registerSprite(Properties props, String key, String textureDefault, dxa textureMap) {
        qv locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new qv("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        qv locSprite = new qv(texture);
        dxb sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        if (facing == fb.b || facing == fb.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bmv block = blockState.d();
        if (block instanceof bqi) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bpf) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmw.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bmw.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bpe) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        boolean snowy;
        bmv blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmw.cC || blockUp == bmw.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmw.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmw.dL) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmw.iw) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        boolean snowy;
        bmv blockTop = BetterGrass.getBlockAt(blockPos, fb.b, blockAccess);
        boolean bl = snowy = blockTop == bmw.cC || blockTop == bmw.cA;
        if (Config.isBetterGrassFancy()) {
            ew posSide;
            bvt stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmw.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.e_(posSide = blockPos.c().a(facing))).d() == bmw.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        bmv blockTop = BetterGrass.getBlockAt(blockPos, fb.b, blockAccess);
        if (blockTop == bmw.iw && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmw.iw) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(bgz blockAccess, bvt blockState, ew blockPos, fb facing, List quads) {
        boolean snowy;
        bmv blockUp = blockAccess.e_(blockPos.b()).d();
        boolean bl = snowy = blockUp == bmw.cC || blockUp == bmw.cA;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bmw.cA) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bmw.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bmv getBlockAt(ew blockPos, fb facing, bgz blockAccess) {
        ew pos = blockPos.a(facing);
        bmv block = blockAccess.e_(pos).d();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

