/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;

public class TrunkTreeFeature
extends TreeFeatureBase {
    protected TrunkTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, height, 1)) {
            return false;
        }
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.func_177981_b(step);
            if (step == heightMinusTop) {
                this.setLog(changedBlocks, world, offsetPos, boundingBox);
                break;
            }
            this.setLog(changedBlocks, world, offsetPos, boundingBox);
        }
        return true;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, TrunkTreeFeature> {
        public Builder() {
            this.minHeight = 7;
            this.maxHeight = 11;
        }

        @Override
        public TrunkTreeFeature create() {
            return new TrunkTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

