/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementSlider;
import cofh.lib.gui.element.TabBase;
import cofh.lib.gui.element.listbox.SliderHorizontal;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.gui.container.ContainerRelay;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiRelay
extends GuiBaseAdv {
    static final String TEX_PATH = "thermaldynamics:textures/gui/Relay.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/Relay.png");
    private final Relay relay;
    public ElementButton buttonType;
    public ElementSlider slider;
    private ElementButton buttonInvert;
    ContainerRelay container;

    public GuiRelay(Relay relay) {
        super((Container)new ContainerRelay(relay), TEXTURE);
        this.relay = relay;
        ((GuiBase)this).drawInventory = false;
        ((GuiBase)this).name = "item.thermaldynamics.relay.name";
        this.container = (ContainerRelay)((GuiContainer)this).field_147002_h;
        ((GuiContainer)this).field_147000_g = 74;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!"".equals(this.myInfo)) {
            this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        }
        this.buttonType = new ElementButton((GuiBase)this, 8, 16, "ButtonType", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonType);
        this.buttonInvert = new ElementButton((GuiBase)this, 34, 16, "ButtonInvert", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonInvert);
        this.slider = new SliderHorizontal((GuiBase)this, 62, 16, 100, 20, 15){

            public void onValueChanged(int n) {
                GuiRelay.this.relay.setThreshold((byte)n);
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void onStopDragging() {
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void addTooltip(List<String> list) {
                list.add(StringHelper.localize((String)"info.thermaldynamics.relay.threshold") + " " + ((ElementSlider)this)._value);
            }
        }.setValue((int)this.relay.threshold);
        this.addElement((ElementBase)this.slider);
        this.update();
    }

    private void update() {
        this.slider.setEnabled(this.relay.shouldThreshold());
        this.slider.setVisible(this.relay.shouldThreshold());
        this.buttonType.setSheetX(20 * this.relay.type);
        this.buttonType.setHoverX(20 * this.relay.type);
        this.buttonType.setToolTip("info.thermaldynamics.relay.type." + this.relay.type);
        this.buttonInvert.setSheetX(60 + 20 * this.relay.invert);
        this.buttonInvert.setHoverX(60 + 20 * this.relay.invert);
        this.buttonInvert.setToolTip("info.thermaldynamics.relay.invert." + this.relay.invert);
    }

    public void handleElementButtonClick(String string, int n) {
        int n2;
        super.handleElementButtonClick(string, n);
        int n3 = n2 = n == 0 ? 1 : -1;
        if ("ButtonInvert".equals(string)) {
            this.relay.invert = (byte)((this.relay.invert + 4 + n2) % 4);
            this.relay.sendUpdatePacket();
        } else if ("ButtonType".equals(string)) {
            this.relay.type = (byte)((this.relay.type + 3 + n2) % 3);
            this.relay.sendUpdatePacket();
        }
        this.update();
    }

    protected void func_146979_b(int n, int n2) {
        int n3;
        int n4;
        super.func_146979_b(n, n2);
        if (this.relay.isInput()) {
            n4 = 45;
            n3 = 58;
        } else {
            n3 = 45;
            n4 = 58;
        }
        ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.relayRS") + ": " + this.container.relayPower, 8, n4, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.gridRS") + ": " + this.container.gridPower, 8, n3, 0x404040);
    }
}

