/*
 * Decompiled with CFR 0.152.
 */
package pam.pamhc2crops.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pam.pamhc2crops.Pamhc2crops;
import pam.pamhc2crops.config.EnableConfig;
import pam.pamhc2crops.worldgen.AridGardenFeature;
import pam.pamhc2crops.worldgen.FrostGardenFeature;
import pam.pamhc2crops.worldgen.ShadedGardenFeature;
import pam.pamhc2crops.worldgen.SoggyGardenFeature;
import pam.pamhc2crops.worldgen.TropicalGardenFeature;
import pam.pamhc2crops.worldgen.WindyGardenFeature;

public class WorldGenRegistry {
    public static Feature<NoFeatureConfig> arid_worldgen;
    public static Feature<NoFeatureConfig> frost_worldgen;
    public static Feature<NoFeatureConfig> shaded_worldgen;
    public static Feature<NoFeatureConfig> soggy_worldgen;
    public static Feature<NoFeatureConfig> tropical_worldgen;
    public static Feature<NoFeatureConfig> windy_worldgen;

    public static void registerAll(RegistryEvent.Register<Feature<?>> event) {
        if (!event.getName().equals((Object)ForgeRegistries.FEATURES.getRegistryName())) {
            return;
        }
        IForgeRegistry r = event.getRegistry();
        if (((Boolean)EnableConfig.enable_aridgarden.get()).booleanValue()) {
            arid_worldgen = WorldGenRegistry.register(r, new AridGardenFeature(NoFeatureConfig::func_214639_a), "arid_worldgen");
        }
        if (((Boolean)EnableConfig.enable_frostgarden.get()).booleanValue()) {
            frost_worldgen = WorldGenRegistry.register(r, new FrostGardenFeature(NoFeatureConfig::func_214639_a), "frost_worldgen");
        }
        if (((Boolean)EnableConfig.enable_shadedgarden.get()).booleanValue()) {
            shaded_worldgen = WorldGenRegistry.register(r, new ShadedGardenFeature(NoFeatureConfig::func_214639_a), "shaded_worldgen");
        }
        if (((Boolean)EnableConfig.enable_soggygarden.get()).booleanValue()) {
            soggy_worldgen = WorldGenRegistry.register(r, new SoggyGardenFeature(NoFeatureConfig::func_214639_a), "soggy_worldgen");
        }
        if (((Boolean)EnableConfig.enable_tropicalgarden.get()).booleanValue()) {
            tropical_worldgen = WorldGenRegistry.register(r, new TropicalGardenFeature(NoFeatureConfig::func_214639_a), "tropical_worldgen");
        }
        if (((Boolean)EnableConfig.enable_windygarden.get()).booleanValue()) {
            windy_worldgen = WorldGenRegistry.register(r, new WindyGardenFeature(NoFeatureConfig::func_214639_a), "windy_worldgen");
        }
    }

    private static <V extends R, R extends IForgeRegistryEntry<R>> V register(IForgeRegistry<R> registry, V value, String name) {
        ResourceLocation id = Pamhc2crops.getId(name);
        value.setRegistryName(id);
        registry.register(value);
        return value;
    }
}

