/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.relay;

import cofh.api.block.IBlockConfigGui;
import cofh.api.tileentity.IPortableData;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.render.RenderUtils;
import cofh.lib.util.helpers.ServerHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.gui.client.GuiRelay;
import cofh.thermaldynamics.gui.container.ContainerRelay;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.render.RenderDuct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Relay
extends Attachment
implements IBlockConfigGui,
IPortableData {
    public byte type = 0;
    public int powerLevel;
    public byte invert = 0;
    public byte threshold = 0;

    public Relay(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    public Relay(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by);
        this.type = (byte)n;
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.relay.name";
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public Cuboid6 getCuboid() {
        return TileTDBase.subSelection[this.side].copy();
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return null;
    }

    @Override
    public BlockDuct.ConnectionTypes getRenderConnectionType() {
        return BlockDuct.ConnectionTypes.DUCT;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (n == 1) {
            return false;
        }
        Translation translation = RenderUtils.getRenderVector((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5)).translation();
        RenderDuct.modelConnection[1 + (this.type & 1)][this.side].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.signalTexture)});
        return true;
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalDynamics.itemRelay);
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
        linkedList.add(this.getPickBlock());
        return linkedList;
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        if (this.type == 0 || this.type == 2) {
            int n = this.getRawRedstoneLevel();
            n = this.adjustPowerLevel(n);
            this.setPowerLevel(n);
        }
    }

    public int adjustPowerLevel(int n) {
        if (this.shouldThreshold()) {
            int n2 = n = n >= this.threshold ? 15 : 0;
        }
        if (this.shouldInvert()) {
            n = 15 - n;
        }
        return n;
    }

    public boolean shouldThreshold() {
        return (this.invert & 2) != 0;
    }

    public boolean shouldInvert() {
        return (this.invert & 1) == 1;
    }

    public int getRawRedstoneLevel() {
        TileTDBase tileTDBase;
        int n = ((TileEntity)this.tile).field_145851_c + Facing.field_71586_b[this.side];
        int n2 = ((TileEntity)this.tile).field_145848_d + Facing.field_71587_c[this.side];
        int n3 = ((TileEntity)this.tile).field_145849_e + Facing.field_71585_d[this.side];
        int n4 = 0;
        Block block = this.tile.world().func_147439_a(n, n2, n3);
        if (this.type == 0) {
            if (Relay.isBlockDuct(block)) {
                tileTDBase = (TileTDBase)this.tile.world().func_147438_o(n, n2, n3);
                Attachment attachment = tileTDBase.attachments[this.side ^ 1];
                if (attachment != null) {
                    n4 = attachment.getRSOutput();
                }
            } else {
                n4 = Math.max(n4, this.tile.world().func_72878_l(n, n2, n3, (int)this.side));
                if (block == Blocks.field_150488_af) {
                    n4 = Math.max(n4, this.tile.world().func_72805_g(n, n2, n3));
                }
            }
        }
        if (this.type == 2) {
            if (block.func_149740_M()) {
                n4 = block.func_149736_g(this.tile.world(), n, n2, n3, Direction.field_71579_d[this.side ^ 1]);
            } else if (block.isNormalCube((IBlockAccess)this.tile.world(), n, n2, n3) && (tileTDBase = this.tile.world().func_147439_a(n += Facing.field_71586_b[this.side], n2 += Facing.field_71587_c[this.side], n3 += Facing.field_71585_d[this.side])).func_149740_M()) {
                n4 = tileTDBase.func_149736_g(this.tile.world(), n, n2, n3, Direction.field_71579_d[this.side ^ 1]);
            }
        }
        return n4;
    }

    public static boolean isBlockDuct(Block block) {
        for (BlockDuct blockDuct : ThermalDynamics.blockDuct) {
            if (block != blockDuct) continue;
            return true;
        }
        return false;
    }

    public boolean isInput() {
        return this.type == 0 || this.type == 2;
    }

    public boolean isOutput() {
        return this.type == 1;
    }

    public int getPowerLevel() {
        if (this.type == 1) {
            return this.adjustPowerLevel(this.powerLevel);
        }
        return this.powerLevel;
    }

    @Override
    public int getRSOutput() {
        return this.isOutput() ? this.getPowerLevel() : 0;
    }

    public void setPowerLevel(int n) {
        if (this.powerLevel != n) {
            this.powerLevel = n;
            if (this.tile.myGrid != null) {
                this.tile.myGrid.signalsUpToDate = false;
            }
            if (this.isOutput()) {
                this.tile.world().func_147460_e(((TileEntity)this.tile).field_145851_c + Facing.field_71586_b[this.side], ((TileEntity)this.tile).field_145848_d + Facing.field_71587_c[this.side], ((TileEntity)this.tile).field_145849_e + Facing.field_71585_d[this.side], this.tile.func_145838_q());
                for (int i = 0; i < 6; ++i) {
                    if (this.side == (i ^ 1)) continue;
                    this.tile.world().func_147460_e(((TileEntity)this.tile).field_145851_c + Facing.field_71586_b[this.side] + Facing.field_71586_b[i], ((TileEntity)this.tile).field_145848_d + Facing.field_71587_c[this.side] + Facing.field_71587_c[i], ((TileEntity)this.tile).field_145849_e + Facing.field_71585_d[this.side] + Facing.field_71585_d[i], this.tile.func_145838_q());
                }
            }
        }
    }

    @Override
    public void checkSignal() {
        MultiBlockGrid multiBlockGrid = this.tile.myGrid;
        if (multiBlockGrid == null || multiBlockGrid.rs == null) {
            return;
        }
        this.setPowerLevel(multiBlockGrid.rs.redstoneLevel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask() {
        return CoverHoleRender.hollowDuctTile;
    }

    @Override
    public boolean respondsToSignallum() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74774_a("type", this.type);
        nBTTagCompound.func_74774_a("invert", this.invert);
        nBTTagCompound.func_74774_a("threshold", this.threshold);
        nBTTagCompound.func_74774_a("power", (byte)this.powerLevel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.type = nBTTagCompound.func_74771_c("type");
        if (nBTTagCompound.func_150297_b("invert", 1)) {
            this.setInvert(nBTTagCompound.func_74771_c("invert"));
        }
        if (nBTTagCompound.func_150297_b("threshold", 1)) {
            this.setThreshold(nBTTagCompound.func_74771_c("threshold"));
        }
        this.powerLevel = nBTTagCompound.func_74771_c("power");
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
        packetCoFHBase.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
        this.type = packetCoFHBase.getByte();
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (ServerHelper.isClientWorld((World)this.tile.world())) {
            return true;
        }
        PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)entityPlayer);
        entityPlayer.openGui((Object)ThermalDynamics.instance, 1 + this.side, this.tile.func_145831_w(), ((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
        return true;
    }

    @Override
    public boolean shouldRSConnect() {
        return true;
    }

    @Override
    public boolean canAddToTile(TileTDBase tileTDBase) {
        return !tileTDBase.getDuctType().isLargeTube();
    }

    public void setInvert(byte by) {
        this.invert = by;
    }

    public void setThreshold(byte by) {
        this.threshold = by;
    }

    public boolean openConfigGui(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiRelay(this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerRelay(this);
    }

    public void sendUpdatePacket() {
        PacketHandler.sendToServer((PacketBase)this.getPacket());
    }

    public PacketTileInfo getPacket() {
        PacketTileInfo packetTileInfo = this.getNewPacket();
        packetTileInfo.addByte(this.type);
        packetTileInfo.addByte(this.threshold);
        packetTileInfo.addByte(this.invert);
        return packetTileInfo;
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        super.handleInfoPacket(packetCoFHBase, bl, entityPlayer);
        byte by = this.type;
        this.type = packetCoFHBase.getByte();
        this.threshold = packetCoFHBase.getByte();
        this.invert = packetCoFHBase.getByte();
        if (bl) {
            this.tile.world().func_147459_d(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e, this.tile.func_145838_q());
            this.onNeighborChange();
            if (this.type != by && this.tile.myGrid != null) {
                this.tile.myGrid.resetRelays();
            }
        }
        this.tile.world().func_147471_g(this.tile.x(), this.tile.y(), this.tile.z());
    }

    @Override
    public void sendGuiNetworkData(Container container, List list, boolean bl) {
        super.sendGuiNetworkData(container, list, bl);
        if (bl) {
            for (Object e : list) {
                if (!(e instanceof EntityPlayer)) continue;
                PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)((EntityPlayer)e));
            }
        }
    }

    public String getDataType() {
        return "RedstoneRelay";
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.readFromNBT(nBTTagCompound);
        this.tile.world().func_147459_d(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e, this.tile.func_145838_q());
        this.onNeighborChange();
        if (this.tile.myGrid != null) {
            this.tile.myGrid.resetRelays();
        }
        this.onNeighborChange();
        this.tile.world().func_147471_g(this.tile.x(), this.tile.y(), this.tile.z());
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.writeToNBT(nBTTagCompound);
    }
}

