/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.hash.TIntFloatHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public final class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int gameTicks = 0;
    public static float midGameTick = 0.0f;
    static TIntFloatHashMap prevTime = new TIntFloatHashMap();

    public static void initShaders() {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        FMLCommonHandler.instance().bus().register((Object)new ShaderHelper());
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.END) {
            return;
        }
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen == null || !guiScreen.func_73868_f()) {
            ++gameTicks;
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.END) {
            return;
        }
        midGameTick = renderTickEvent.renderTickTime;
    }

    public static void useShader(int n, ShaderCallback shaderCallback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)n);
        if (n != 0) {
            boolean bl;
            float f = (float)gameTicks + midGameTick;
            boolean bl2 = bl = f != prevTime.get(n);
            if (bl) {
                int n2 = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"time");
                ARBShaderObjects.glUniform1fARB((int)n2, (float)f);
                prevTime.put(n, f);
            }
            if (shaderCallback != null) {
                shaderCallback.call(n, bl);
            }
        }
    }

    public static void useShader(int n) {
        ShaderHelper.useShader(n, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g && CoFHProps.enableShaderEffects;
    }

    public static int createProgram(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string != null) {
            n = ShaderHelper.createShader(string, 35633);
        }
        if (string2 != null) {
            n2 = ShaderHelper.createShader(string2, 35632);
        }
        if ((n3 = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (string != null) {
            ARBShaderObjects.glAttachObjectARB((int)n3, (int)n);
        }
        if (string2 != null) {
            ARBShaderObjects.glAttachObjectARB((int)n3, (int)n2);
        }
        ARBShaderObjects.glLinkProgramARB((int)n3);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)n3, (int)35714) == 0) {
            CoFHCore.log.error(ShaderHelper.getLogInfo(n3));
            ARBShaderObjects.glDeleteObjectARB((int)n3);
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)n3);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)n3, (int)35715) == 0) {
            CoFHCore.log.error(ShaderHelper.getLogInfo(n3));
            ARBShaderObjects.glDeleteObjectARB((int)n3);
            return 0;
        }
        prevTime.put(n3, -1.0f);
        return n3;
    }

    private static int createShader(String string, int n) {
        int n2 = 0;
        try {
            n2 = ARBShaderObjects.glCreateShaderObjectARB((int)n);
            if (n2 == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)n2, (CharSequence)ShaderHelper.readFileAsString(string));
            ARBShaderObjects.glCompileShaderARB((int)n2);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)n2, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(n2));
            }
            return n2;
        }
        catch (Exception exception) {
            ARBShaderObjects.glDeleteObjectARB((int)n2);
            exception.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int n) {
        return ARBShaderObjects.glGetInfoLogARB((int)n, (int)ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = ShaderHelper.class.getResourceAsStream(string);
        Exception exception = null;
        BufferedReader bufferedReader = null;
        if (inputStream == null) {
            return "";
        }
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2).append('\n');
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            finally {
                if (exception != null) {
                    throw exception;
                }
            }
        }
        return stringBuilder.toString();
    }

    public static abstract class ShaderCallback {
        public abstract void call(int var1, boolean var2);
    }
}

